﻿using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.IO;
using Microsoft.DirectX;
using Microsoft.DirectX.AudioVideoPlayback;

namespace SimpleMedia
{
	/// <summary>
	/// Summary description for SimpleMediaPlayerForm.
	/// </summary>
	public class SimpleMediaPlayerForm : System.Windows.Forms.Form
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.MainMenu mainMenu1;
		private System.Windows.Forms.MenuItem menuItem1;
		private System.Windows.Forms.MenuItem menuOpenFile;
		private System.Windows.Forms.MenuItem menuExit;
		private System.Windows.Forms.StatusBar statusBar1;
		private System.Windows.Forms.ListBox listBox1;
		private System.Windows.Forms.Button button1;
		private System.Windows.Forms.OpenFileDialog openMediaFileDialog;
 		private System.Windows.Forms.MenuItem menuItem2;
		private System.Windows.Forms.MenuItem menuItem3;

		private Audio myAudio = null;
		private int currentItem = 0;
		private System.Windows.Forms.StatusBarPanel statusBarPanel1;
		private System.Windows.Forms.StatusBarPanel statusBarPanel2;
		private Boolean isPlaying = false;
		private AboutBox myAboutBox;

		public SimpleMediaPlayerForm()
		{                                                      
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
			myAboutBox = new AboutBox();

		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose (bool disposing)
		{
			if (disposing)
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			if (myAudio != null)
			{
             	myAudio.Dispose();
			}
			myAboutBox.Dispose();
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.mainMenu1 = new System.Windows.Forms.MainMenu();
			this.menuItem1 = new System.Windows.Forms.MenuItem();
			this.menuOpenFile = new System.Windows.Forms.MenuItem();
			this.menuExit = new System.Windows.Forms.MenuItem();
			this.menuItem2 = new System.Windows.Forms.MenuItem();
			this.menuItem3 = new System.Windows.Forms.MenuItem();
			this.statusBar1 = new System.Windows.Forms.StatusBar();
			this.statusBarPanel1 = new System.Windows.Forms.StatusBarPanel();
			this.statusBarPanel2 = new System.Windows.Forms.StatusBarPanel();
			this.listBox1 = new System.Windows.Forms.ListBox();
			this.button1 = new System.Windows.Forms.Button();
			this.openMediaFileDialog = new System.Windows.Forms.OpenFileDialog();
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanel1)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanel2)).BeginInit();
			this.SuspendLayout();
			// 
			// mainMenu1
			// 
			this.mainMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
						this.menuItem1,
						this.menuItem2});
			// 
			// menuItem1
			// 
			this.menuItem1.Index = 0;
			this.menuItem1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
						this.menuOpenFile,
						this.menuExit});
			this.menuItem1.Text = "File";
			// 
			// menuOpenFile
			// 
			this.menuOpenFile.Index = 0;
			this.menuOpenFile.Text = "Add Audio File";
			this.menuOpenFile.Click += new System.EventHandler(this.menuOpenFile_Click);
			// 
			// menuExit
			// 
			this.menuExit.Index = 1;
			this.menuExit.Text = "Exit";
			this.menuExit.Click += new System.EventHandler(this.menuExit_Select);
			this.menuExit.Select += new System.EventHandler(this.menuExit_Select);
			// 
			// menuItem2
			// 
			this.menuItem2.Index = 1;
			this.menuItem2.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
						this.menuItem3});
			this.menuItem2.Text = "Help";
			// 
			// menuItem3
			// 
			this.menuItem3.Index = 0;
			this.menuItem3.Text = "About";
			this.menuItem3.Click += new System.EventHandler(this.menuItem3_Click);
			// 
			// statusBar1
			// 
			this.statusBar1.Location = new System.Drawing.Point(0, 244);
			this.statusBar1.Name = "statusBar1";
			this.statusBar1.Panels.AddRange(new System.Windows.Forms.StatusBarPanel[] {
						this.statusBarPanel1,
						this.statusBarPanel2});
			this.statusBar1.Size = new System.Drawing.Size(292, 22);
			this.statusBar1.TabIndex = 0;
			// 
			// statusBarPanel1
			// 
			this.statusBarPanel1.Text = "Please choose a song.";
			// 
			// statusBarPanel2
			// 
			this.statusBarPanel2.Text = "No playing time";
			// 
			// listBox1
			// 
			this.listBox1.Dock = System.Windows.Forms.DockStyle.Fill;
			this.listBox1.Location = new System.Drawing.Point(0, 0);
			this.listBox1.Name = "listBox1";
			this.listBox1.SelectionMode = System.Windows.Forms.SelectionMode.MultiSimple;
			this.listBox1.Size = new System.Drawing.Size(292, 238);
			this.listBox1.TabIndex = 1;
			this.listBox1.SelectedIndexChanged += new System.EventHandler(this.listBox1_SelectedIndexChanged);
			// 
			// button1
			// 
			this.button1.Dock = System.Windows.Forms.DockStyle.Bottom;
			this.button1.Enabled = false;
			this.button1.Location = new System.Drawing.Point(0, 221);
			this.button1.Name = "button1";
			this.button1.Size = new System.Drawing.Size(292, 23);
			this.button1.TabIndex = 2;
			this.button1.Text = "Play";
			this.button1.Click += new System.EventHandler(this.button1_Click);
			// 
			// openMediaFileDialog
			// 
			this.openMediaFileDialog.DefaultExt = "*.wav";
			this.openMediaFileDialog.Filter = "Audio Files (*wav,*.au,*.mp3,*.wma,*.mid)|*.wav;*.au;*.mp3;*.wma;*" +  
				".mid";
			this.openMediaFileDialog.Title = "Select an audio file";
			// 
			// SimpleMediaPlayerForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(292, 266);
			this.Controls.Add(this.button1);
			this.Controls.Add(this.listBox1);
			this.Controls.Add(this.statusBar1);
			this.Menu = this.mainMenu1;
			this.Name = "SimpleMediaPlayerForm";
			this.Text = "SimpleMediaPlayerForm";
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanel1)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanel2)).EndInit();
			this.ResumeLayout(false);
		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new SimpleMediaPlayerForm());
		}
		
		private void menuExit_Select(object sender, System.EventArgs e)
		{
			Application.Exit();
		}
		
		private void menuOpenFile_Click(object sender, System.EventArgs e)
		{
			openMediaFileDialog.ShowDialog(this);
			string newEntry = openMediaFileDialog.FileName;
			listBox1.Items.Add( newEntry );
		}

		private void listBox1_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			updatePlayButtonStatus();
		}

		private void updatePlayButtonStatus()
		{
			//selectedFileName = (string) listBox1.SelectedItem;
			if (isPlaying)
			{
				// if we're playing, make sure we're enabled AND
				// ready to "stop" playing
				//MessageBox.Show("update play case #1");
				button1.Text = "stop";
				listBox1.Enabled = false;
			}
			else  // not playing
			{   
				button1.Text = "play";
				listBox1.Enabled = true;
				if (listBox1.SelectedItems != null && listBox1.SelectedItems.Count > 0)
				{                   
					button1.Enabled = true;
				}
				else
				{
					button1.Enabled = false;
				}
			}
		}
		
		private void button1_Click(object sender, System.EventArgs e)
		{
			if(isPlaying){
				ceaseTracks();
			} else {
				initAudio();
				playNextTrack();
			}
		}

		private void playNextTrack()
		{
			// let's play!
			isPlaying = true;
			if( currentItem >= listBox1.SelectedItems.Count)
			{
				//MessageBox.Show("About to cease tracks from playNextTrack");
				ceaseTracks();                                              
				//MessageBox.Show("Ceased tracks from playNextTrack");
				return;
			}
			myAudio.Open((string)listBox1.SelectedItems[currentItem]);
			myAudio.Play();
			statusBar1.Text = "Now Playing" + (string) listBox1.SelectedItems[currentItem]
				+ " : " + myAudio.Duration;
			updatePlayButtonStatus();
		}

		private void initAudio()
		{    			
			currentItem = 0;
			myAudio = new Audio((string)listBox1.SelectedItems[currentItem]);
			myAudio.Ending += new System.EventHandler(this.ClipEnded);
		}

		private void ceaseTracks()
		{
			isPlaying = false;
			if (myAudio != null)
			{
				myAudio.Stop();
			}
			updatePlayButtonStatus();

		}

		private void ClipEnded(Object sender, System.EventArgs e)
		{
			currentItem++;
			if(currentItem >= listBox1.SelectedItems.Count)
			{
				//MessageBox.Show("About to cease tracks from ClipEnded");
				ceaseTracks();
			}
			else
			{
				//MessageBox.Show("About to play the next track");
				myAudio.Stop();
				playNextTrack();
			}
		}
		
		private void menuItem3_Click(object sender, System.EventArgs e)
		{
			myAboutBox.Show();
		}
		
		

	}
}
